<?php
namespace App\Models;

use App\Core\DB;

class UserModel
{
    public static function findByUsername(string $username): ?array
    {
        $stmt = DB::get()->prepare("SELECT * FROM users WHERE username = ? LIMIT 1");
        $stmt->execute([$username]);
        $row = $stmt->fetch();
        return $row ?: null;
    }

    public static function findById(int $id): ?array
    {
        $stmt = DB::get()->prepare("SELECT * FROM users WHERE id = ? LIMIT 1");
        $stmt->execute([$id]);
        $row = $stmt->fetch();
        return $row ?: null;
    }

    public static function updatePassword(int $id, string $hash): void
    {
        $stmt = DB::get()->prepare("UPDATE users SET password_hash = ?, updated_at = datetime('now') WHERE id = ?");
        $stmt->execute([$hash, $id]);
    }
}
